<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Control de Asistencias – Gobierno del Estado de Tamaulipas</title>
    <style>
        body { margin:0;padding:0;font-family:"Segoe UI",sans-serif;background:#f5f5f5;}
        .header { background-color:#6A1B21;padding:15px 20px;display:flex;align-items:center;color:white;border-bottom:4px solid #C9A43F;}
        .header img {height:65px;margin-right:15px;}
        .header h1 {margin:0;font-size:22px;font-weight:bold;}
        .login-container {max-width:430px;margin:60px auto;background:white;padding:35px;border-radius:10px;border-top:10px solid #6A1B21;box-shadow:0 4px 12px rgba(0,0,0,0.15);}
        .login-container h2 {text-align:center;color:#6A1B21;margin-bottom:20px;font-size:22px;}
        label {font-weight:bold;color:#333;}
        input {width:100%;padding:12px;margin-top:5px;margin-bottom:18px;border:2px solid #ccc;border-radius:6px;font-size:16px;}
        input:focus {border-color:#6A1B21;outline:none;}
        .btn-login {width:100%;padding:12px;background:#6A1B21;color:white;font-size:17px;border:none;border-radius:6px;cursor:pointer;font-weight:bold;}
        .btn-login:hover {background:#52161A;}
        .footer {text-align:center;margin-top:25px;color:#777;font-size:14px;}
    </style>
</head>
<body>
    <div class="header">
        <img src="https://www.tamaulipas.gob.mx/wp-content/themes/gobtam-2022/img/logoTamaulipas2022.png" alt="Logo Tamaulipas">
        <h1>Control de Asistencias – Gobierno del Estado de Tamaulipas</h1>
    </div>

    <div class="login-container">
        <h2>Iniciar Sesión</h2>
        <form action="auth/login_process.php" method="POST">
            <label>Usuario</label>
            <input type="text" name="usuario" required placeholder="Ingrese su usuario">
            <label>Contraseña</label>
            <input type="password" name="password" required placeholder="Ingrese su contraseña">
            <button class="btn-login" type="submit">Entrar</button>
        </form>
    </div>

    <div class="footer">
        © Gobierno del Estado de Tamaulipas – 2025
    </div>
</body>
</html>