<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Dashboard – Gobierno del Estado de Tamaulipas</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<style>
body{margin:0;font-family:"Segoe UI",sans-serif;background:#f5f5f5;display:flex;}
.sidebar{width:260px;height:100vh;background:#6A1B21;color:white;position:fixed;left:0;top:0;padding-top:25px;}
.sidebar img{width:90%;display:block;margin:0 auto 20px auto;}
.sidebar h2{text-align:center;font-size:18px;margin-bottom:20px;}
.menu{list-style:none;padding:0;}
.menu li{padding:14px 20px;font-size:16px;border-left:4px solid transparent;cursor:pointer;}
.menu li a{color:white;text-decoration:none;}
.menu li:hover{background:#52161A;border-left:4px solid #C9A43F;}
.content{margin-left:260px;padding:30px;width:calc(100% - 260px);}
.content h1{color:#6A1B21;font-size:28px;margin-bottom:15px;}
.cards{display:flex;gap:20px;margin-top:20px;flex-wrap:wrap;}
.card{background:white;padding:20px;border-radius:10px;width:280px;flex-grow:1;box-shadow:0 4px 10px rgba(0,0,0,0.12);border-top:6px solid #C9A43F;}
.card h3{margin:0;color:#6A1B21;font-size:20px;}
.card p{color:#444;font-size:16px;margin-top:10px;}
.logout{position:absolute;bottom:20px;left:20px;right:20px;}
.logout a{display:block;padding:12px;background:#C9A43F;color:black;text-align:center;font-weight:bold;border-radius:6px;text-decoration:none;}
.logout a:hover{background:#b79534;}
</style>
</head>
<body>
<div class="sidebar">
<img src="https://www.tamaulipas.gob.mx/wp-content/themes/gobtam-2022/img/logoTamaulipas2022.png">
<h2>Menú Principal</h2>
<ul class="menu">
<li><a href="dashboard.php"><i class="fa-solid fa-house"></i> Inicio</a></li>
<li><a href="pages/asistencia.php"><i class="fa-solid fa-calendar-check"></i> Registrar Asistencia</a></li>
<li><a href="pages/usuarios.php"><i class="fa-solid fa-users"></i> Usuarios</a></li>
<li><a href="pages/reportes.php"><i class="fa-solid fa-file-lines"></i> Reportes</a></li>
</ul>
<div class="logout">
<a href="auth/logout.php"><i class="fa-solid fa-right-from-bracket"></i> Cerrar Sesión</a>
</div>
</div>

<div class="content">
<h1>Bienvenido, <?php echo ucfirst($_SESSION['user']); ?> 👋</h1>
<p>Sistema de Control de Asistencias – Gobierno de Tamaulipas</p>
<div class="cards">
<div class="card"><h3>Asistencias del día</h3><p>Consulta el registro diario de entradas y salidas.</p></div>
<div class="card"><h3>Usuarios activos</h3><p>Administra personal y sus roles dentro del sistema.</p></div>
<div class="card"><h3>Reportes</h3><p>Genera informes y documentos oficiales.</p></div>
</div>
</div>
</body>
</html>
